 ; Front - move entities to the end of the database and thus to the front.
 ; Back - move entities to the back.
 ; Fra - move entities to the front using the copy method.
 ; Fronts - move a single entity to the front.
 ; Frob - move block inserts to the front.
 ; Froh - move everything but hatches to the front.
 ; Fhit - move all wipeouts to the front, then all text.
 ; Fhor - move all hatches to the back.
 ; Frot - move text (optionally all text) to the front.
 ; Copyright 1996, 2001, 2002, 2008 - 2010 by Rocket Software Ltd.
 ; Predates the similar built-in command, and is slightly less clunky.
 ; Revised - now uses Draworder.

 ; Fra - move entities to the end of the database and thus to the front.
 ; Uses the original method, and thus will change attribute order and
 ; can be used to add stuff to blocks being edited with Chat/Chab.
 (DEFUN C:FRA (/ ss enam num)
  (prompt "Select entities to move to front: ")
  (setq ss (ssget))
  (setq num 0)
  (while (and ss (setq enam (ssname ss num)))
         (setq num (1+ num))
         (command "copy" enam "" "0,0" "0,0")
         (entdel enam)
         (redraw (entlast)))
 (princ))


 (DEFUN C:BACK (/ ss)
  (prompt "Select entities to move to the back: ")
  (if (setq ss (ssget))
      (command "draworder" ss "" "back"))
 (princ))


 (DEFUN C:FROB (/ ss enampt enam blnam)
  (prompt "Select inserts to move to front or <Return> for all of one type: ")
  (if (or (setq ss (ssget '((0 . "insert"))))
          (and (setq enampt (entsel "Example Block: "))
               (setq enam (car enampt))
               (setq blnam (assoc 2 (entget enam)))
               (setq ss (ssget "x" (list blnam)))))
      (command "draworder" ss "" "front"))
 (princ))

 (DEFUN C:FROH (/ ss)
  (prompt "Select non-hatch entities to move to front: ")
  (if (setq ss (ssget '((-4 . "<>") (0 . "hatch"))))
      (command "draworder" ss "" "front"))
 (princ))

 (DEFUN C:FHIT (/ ss)
  (setq ss (ssget "x" '((0 . "wipeout"))))
  (if ss (command "draworder" ss "" "front"))
  (setq ss (ssget "x" '((0 . "text"))))
  (if ss (command "draworder" ss "" "front"))
 (princ))

 (DEFUN C:FHOR (/ ss)
  (prompt "Moving Hatches to the Back: ")
  (if (setq ss (ssget "x" '((0 . "hatch"))))
      (command "draworder" ss "" "back"))
 (princ))

 (DEFUN C:FROT (/ ss)
  (prompt "Select text entities to move to front or <All Text>: ")
  (if (null (setq ss (ssget '((0 . "text")))))
      (setq ss (ssget "x" '((0 . "text")))))
  (if ss (command "draworder" ss "" "front"))
 (princ))

 (DEFUN C:FRONT (/ ss)
  (prompt "Select entities to move to front: ")
  (if (setq ss (ssget))
      (command "draworder" ss "" "front"))
 (princ))

 (DEFUN C:FRONTS (/ enam)
  (if (setq enam (car (entsel "Entity to move to front: ")))
      (command "draworder" enam "" "front"))
 (princ))

